//OHSAT GAMES MEGATILER TUTORIAL - SPAWNING THE PLAYER- https://www.ohsat.com/tutorial/megatiler/megatiler-2/
//MEGATEAMWORK Makes the MEGADREAM Work 
//SGDK Version: 2.0 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>
 
#define SPAWN_TILE 4    //value for player sprite for use in array
#define TILESIZE 8      //pixel value tile size
#define MAP_WIDTH 8     //pixel value for tile width
#define MAP_HEIGHT 8    //pixel value for tile height

typedef struct {
    u8 x;
    u8 y; 
}Point;

typedef enum {up,down,left,right,none} moveDirection;

typedef struct
{
    Point pos;
    Point tilePos;
    int w; 
    int h;
    int health;
    bool moving;
    moveDirection dir;
    Sprite* sprite;
    char name[6];
}Entity;

Entity player = {{0, 0}, {0, 0}, 8, 8, 0, FALSE, none, NULL, "PLAYER"};

void loadLevel();

int main()
{   
    loadLevel();
    
   
    while(1)
    {
        SPR_update(); //update sprite display during gameplay
    
        //For versions prior to SGDK 1.60 use VDP_waitVSync instead.
        SYS_doVBlankProcess();
    }
    return (0);
}

void loadLevel(){
    // 4 is player sprite, 0 is grass tile, 1 is wall tile.
    u8 level1[8][8] = {
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 1, 1, 0, 0, 0},
        {4, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0}
    };

    u8 x = 0;
    u8 y = 0;
    u8 t = 0;

    SPR_init();
    for(y = 0; y < MAP_HEIGHT; y++){
        for (x = 0; x < MAP_WIDTH; x++){
            t = level1[y][x];
            if (t == SPAWN_TILE)
            {
                player.tilePos.x = x;
                player.tilePos.y = y;

                player.pos.x = player.tilePos.x * TILESIZE;
                player.pos.y = player.tilePos.y * TILESIZE;

                player.sprite = SPR_addSprite(&spr_player, player.pos.x, player.pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }else{
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
            }
            
            
        }
    }
    //moved from main() into loadLevel() to possibly use later for Levels.h header file. 
    VDP_loadTileSet(floortiles.tileset, 1, DMA);
    //VDP_setPalette(PAL1, floortiles.palette->data); //Deprecated command: VDP_setPalette
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
    PAL_setPalette(PAL2, spr_player.palette->data, DMA);
    
    //moved array from above main() & void loadLevel(); predeclaration 
    

}


////////////////////NOTES////////////////////

/*

1. Add the player sprite into resources.res

SPRITE [TYPE] spr_player [LABEL] "Sprites/player.png" [RESOURCE PATH] 1 1 [w h] NONE [COMPRESSION] 20 [FRAMERATE]

2. Creating Entity and Point structs to position the player entity/tile and handled entity/player attributes
above main()

Pointer struct:

typedef struct{
u8 x;
u8 y;
} Point;

typedef enum {UP, DOWN, LEFT, RIGHT, NONE} moveDirection;

typedef struct{
Point pos;
Point tilePos;
int w;
int h;
int health;
bool moving;
moveDirection dir;
Sprite *sprite;
char name[6];
} Entity;

3. Adding #define(s) needed for calculating tile size and map positioning

#define SPAWN_TILE 4    //value for player sprite for use in level1 array
#define TILESIZE 8      //pixel value tile size
#define MAP_WIDTH 8     //pixel value for tile width
#define MAP_HEIGHT 8    //pixel value for tile height

4. Update loadLevel() function to accomodate new variables for player/map parameters

//...
SPR_init(); //initialize sprites
for(y = 0; y < MAP_HEIGHT; y++){ //replaced integer 8 with #define MAP_HEIGHT 
    for (x = 0; x < MAP_WIDTH; x++){ //replaced integer 8 with #define MAP_WIDTH
        t = level1[y][x];

        //adding condition for t value is SPAWN_TILE i.e. 4 in the level1 array
        if (t == SPAWN_TILE){
            //Spawn the player
        } else{
            VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
        }
    }
}

5. Adding the player entity above main() 

Entity player = {{0,0}, {0,0}, 8, 8, 0, FALSE, NONE, NULL, "PLAYER"};

Referencing Entity struct as it is applied to Entity > player

Entity [STRUCT] player [LABEL] = {  {Point [STRUCT] pos [LABEL] x, y [ATTR] 0, 0 [VALUE]}; 
{Entity [STRUCT] Point [STRUCT] tilePos [LABEL] x, y [ATTR] 0, 0 [VALUE]}; 
int [ATTR] w [LABEL]  8 [VALUE];
int [ATTR] h [LABEL] 8 [VALUE]; 
int [ATTR] health [LABEL] 0 [VALUE];
bool [ATTR] moving [LABEL] FALSE [VALUE];
moveDirection [ENUM] dir [LABEL] NONE [VALUE];
Sprite [ATTR] *sprite [REFERENCE] NULL [VALUE];
char [ATTR] name[6] [array label and character limit value] "PLAYER" [VALUE]
      };

Note: Structs within a struct are enclosed with braces/curly brackets {}

6. Return to the if() statement within loadLevel() function to define player pos & tilepos

                player.tilePos.x = x;
                player.tilePos.y = y;

                player.pos.x = player.tilePos.x * TILESIZE;
                player.pos.y = player.tilePos.y * TILESIZE;

7. Create the player sprite with SPR_addSprite() function using the player.pos x & y integer attributes 
Note: Andrej is assigning the player sprite to PAL2. We will assign the sprite to PAL2 later in the code.

player.sprite = SPR_addSprite(&spr_player, player.pos.x, player.pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));

8. Within the if(t == SPAWN_TILE) condition statement, ensure a grass tile (of array value 0 & index value 1) is drawn
behind the player sprite  

                player.sprite = SPR_addSprite(&spr_player, player.pos.x, player.pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);

The if(t == SPAWN_TILE) will ensure the positioning and drawing of assets at designated position is appears within the level1 array. 
The else() statement below the if() statement handles the drawing of the on-screen tile assets that don't pertain to the player (SPAWN_TILE). 

9. Adding SPR_update to the while(1) loop & declaring the player sprite to VDP PAL2 using PAL_setPalette() function

Note: VDP_setPalette() function in the tutorial was deprecated and replaced with PAL_setPalette() function

    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
    PAL_setPalette(PAL2, spr_player.palette->data, DMA);

Updated while(1) loop

    while(1)
    {
        SPR_update(); //update sprite display during gameplay
    
        //For versions prior to SGDK 1.60 use VDP_waitVSync instead.
        SYS_doVBlankProcess();
    }

10. Updated loadLevel() function

void loadLevel(){
    
    //level1 array
    // 4 is player sprite, 0 is grass tile, 1 is wall tile.
    // You could consider replacing the integers of [8][8] to use the #define(s) of [MAP_HEIGHT] & [MAP_WIDTH]

    u8 level1[8][8] = {
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 1, 1, 0, 0, 0},
        {4, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0}
    };

    //declared integer variables

    u8 x = 0;
    u8 y = 0;
    u8 t = 0;

    //Sprite initialization, positioning, & drawing functions

    SPR_init();
    for(y = 0; y < MAP_HEIGHT; y++){
        for (x = 0; x < MAP_WIDTH; x++){
            t = level1[y][x];
            if (t == SPAWN_TILE)
            {
                player.tilePos.x = x;
                player.tilePos.y = y;

                player.pos.x = player.tilePos.x * TILESIZE;
                player.pos.y = player.tilePos.y * TILESIZE;

                player.sprite = SPR_addSprite(&spr_player, player.pos.x, player.pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }else{
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
            }
            
            
        }
    }
    
    //Tile assignment
    //moved from main() into loadLevel() to possibly use later for Levels.h header file. 
    //loading floortiles tileset into index spots 1 through 3. Index position 0 is usually a black background tile.
    //Note: If you're using BlastEm emulator, you can press 'V' to see your indexed assets. 

    VDP_loadTileSet(floortiles.tileset, 1, DMA);

    //Palette assignments
    
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
    PAL_setPalette(PAL2, spr_player.palette->data, DMA);

*/

/////////EXPERIMENTATION IDEAS///////////////

/*

1. Try changing out the integer values of 8 and 8 in the level1 array to MAP_HEIGHT & MAP_WIDTH
2. To understand priority in the code, see if you can break it by changing around the order of certain things in your code. 

Example: 

Swap the positions of Line A & Line B in your code, save/clean/compile, and then see what happens

LINE A: player.sprite = SPR_addSprite(&spr_player, player.pos.x, player.pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
LINE B: VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);

3. If you're feeling really adventurous, you can try making your own array and use a different tileset. I've includeded
other assets in the Maps, Sprite, and Tiles folders. I've even included a Music and SFX folders. Go nuts! 

When making your arrays remember your screen dimensions. 

NTSC Standard H40 Mode:     320w x 224h   VDP_setScreenWidth320       40 tiles by 28 tiles
NTSC Letterboxed H32 Mode:  256w x 224h       VDP_setScreenWidth256   32 tiles by 28 tiles
PAL Standard: Height increases by 2 tiles or from 224h to 240h. 

*/

///////////ERROR HANDLING////////////////////

